@extends('admin/layouts/default')

{{-- Page title --}}
@section('title')
    @lang('news/title.newslist')
    @parent
@stop

{{-- page level styles --}}
@section('header_styles')
    <link rel="stylesheet" type="text/css"
          href="{{ asset('assets/vendors/datatables/css/dataTables.bootstrap.css') }}"/>
    <link href="{{ asset('assets/css/pages/tables.css') }}" rel="stylesheet" type="text/css"/>
@stop


{{-- Page content --}}
@section('content')
    <section class="content-header">
        <h1>@lang('news/title.news')</h1>
        <ol class="breadcrumb">
            <li>
                <a href="{{ route('admin.dashboard') }}">
                    <i class="material-icons breadmaterial">home</i>
                    @lang('general.dashboard')
                </a>
            </li>
            <li><a href="#">@lang('news/title.news')</a></li>
            <li class="active">@lang('news/title.newslist')</li>
        </ol>
    </section>

    <!-- Main content -->
    <section class="content paddingleft_right15">
        <div class="row">
            <div class="panel panel-primary ">
                <div class="panel-heading clearfix">
                    <h4 class="panel-title pull-left animate_rtl">
                        <i class="livicon" data-name="edit" data-size="16" data-loop="true" data-c="#fff"
                           data-hc="white"></i> News List
                    </h4>
                    <div class="pull-right">
                        <a href="{{  URL::to('admin/news/create') }}" class="btn btn-sm btn-success"><span
                                    class="glyphicon glyphicon-plus"></span> @lang('button.create')</a>

                    </div>
                </div>

                <br/>
                <div class="panel-body">
                    <div class="table-responsive">
                        <table class="table table-bordered" id="table">
                            <thead>
                            <tr class="filters">
                                <th>@lang('news/table.id')</th>
                                <th>@lang('news/table.title')</th>
                                <th>@lang('news/table.created_at')</th>
                                <th style="width: 70px">@lang('news/table.actions')</th>
                            </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>    <!-- row-->
    </section>
@stop

{{-- page level scripts --}}
@section('footer_scripts')
    <script type="text/javascript" src="{{ asset('assets/vendors/datatables/js/jquery.dataTables.js') }}"></script>
    <script type="text/javascript" src="{{ asset('assets/vendors/datatables/js/dataTables.bootstrap.js') }}"></script>

    <script>
        $(function () {
            var table = $('#table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{!! route('admin.news.data') !!}',
                columns: [
                    {data: 'id', name: 'id'},
                    {data: 'title', name: 'title'},
                    {data: 'created_at', name: 'created_at'},
                    {data: 'actions', name: 'actions', orderable: false, searchable: false}
                ]
            });

        });

    </script>


    {{--<div class="modal fade" id="delete_confirm" tabindex="-1" role="dialog" aria-hidden="true">--}}
    {{--<div class="modal-dialog" role="document">--}}
        {{--<div class="modal-content">--}}
            {{--<div class="modal-header">--}}
                {{--<h4 class="modal-title" id="user_delete_confirm_title">Delete News</h4>--}}
                {{--<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span--}}
                            {{--aria-hidden="true">&times;</span></button>--}}
            {{--</div>--}}
            {{--<div class="modal-body">--}}
                {{--Are you sure to delete this News? This operation is irreversible.--}}
            {{--</div>--}}
            {{--<div class="modal-footer">--}}
                {{--<button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>--}}
                {{--<a type="button" class="btn btn-danger Remove_square">Delete</a>--}}
            {{--</div>--}}
        {{--</div>--}}
        {{--<!-- /.modal-content -->--}}
    {{--</div>--}}
    {{--</div>--}}

    <div class="modal fade" id="delete_confirm1" tabindex="-1" role="dialog" aria-labelledby="deleteLabel"
         aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteLabel">Delete News</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                                aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    Are you sure to delete this News? This operation is irreversible.
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <a type="button" class="btn btn-danger Remove_square">Delete</a>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
    </div>


    {{--<div class="modal fade" id="delete_confirm" tabindex="-1" role="dialog" aria-labelledby="user_delete_confirm_title"--}}
         {{--aria-hidden="true">--}}
        {{--<div class="modal-dialog">--}}
            {{--<div class="modal-content"></div>--}}
        {{--</div>--}}
    {{--</div>--}}

    <script>
        $(function () {
            $('body').on('hidden.bs.modal', '.modal', function () {
                $(this).removeData('bs.modal');
            });
        });

        var $url_path = '{!! url('/') !!}';
        $('#delete_confirm1').on('show.bs.modal', function (event) {
            var button = $(event.relatedTarget)
            var $recipient = button.data('id');
            var modal = $(this)
            modal.find('.modal-footer a').prop("href",$url_path+"/admin/news/"+$recipient+"/delete");
        })
    </script>



@stop
